<%@ Control Language="c#" AutoEventWireup="false" Codebehind="History.ascx.cs" Inherits="Mediachase.UI.Web.Modules.History" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<script language="javascript">

function ObjectClick(Id, TypeId, evt)
{
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt)
	{
		var src = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (src && src.type == "image") return;
	}

	var loc = window.top.right.location;
	if (TypeId == 1) 
		loc.href = "../Directory/UserView.aspx?UserID=" + Id;
	else if (TypeId == 3) 
		loc.href = "../Projects/ProjectView.aspx?ProjectID=" + Id;
	else if (TypeId == 4) 
		loc.href = "../Events/EventView.aspx?EventId=" + Id;
	else if (TypeId == 5) 
		loc.href = "../Tasks/TaskView.aspx?TaskId=" + Id;
	else if (TypeId == 6) 
		loc.href = "../ToDo/ToDoView.aspx?ToDoId=" + Id;
	else if (TypeId == 7) 
		loc.href = "../Incidents/IncidentView.aspx?IncidentId=" + Id;
	else if (TypeId == 15) 
		loc.href = "../Lists/ListView.aspx?ListId=" + Id;
	else if (TypeId == 16) 
		loc.href = "../Documents/DocumentView.aspx?DocumentId=" + Id;
}
</script>

<asp:DataGrid id="dgHistory" Runat="server" AutoGenerateColumns="False" AllowPaging="True" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="True" CssClass="ibn-propertysheet" PagerStyle-Visible="False" PageSize="100">
	<Columns>
		<asp:TemplateColumn>
			<ItemTemplate>
				<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
				onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
				onclick='ObjectClick(<%# DataBinder.Eval(Container.DataItem, "ObjectId") %>, <%# DataBinder.Eval(Container.DataItem, "ObjectTypeId") %>, event)'>
					<tr>
						<td width="30px"></td>
						<td width="50%">
							<%# DataBinder.Eval(Container.DataItem, "ObjectTitle") %>
							<%# (int)DataBinder.Eval(Container.DataItem, "ObjectTypeId") == 7 || (int)DataBinder.Eval(Container.DataItem, "ObjectTypeId") == 3 ? "(#" + DataBinder.Eval(Container.DataItem, "ObjectId").ToString() + ")" : "" %>
						</td>
						<td>
							<%# Mediachase.UI.Web.Util.CommonHelper.GetObjectTypeName((int)DataBinder.Eval(Container.DataItem, "ObjectTypeId")) %>
						</td>
						<td width="160px">
							<%# ((DateTime)DataBinder.Eval(Container.DataItem, "Dt")).ToShortDateString() %>
							<%# ((DateTime)DataBinder.Eval(Container.DataItem, "Dt")).ToShortTimeString() %>
						</td>
					</tr>
				</table>
			</ItemTemplate>
		</asp:TemplateColumn>
	</Columns>
</asp:DataGrid>